<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
require_once '../includes/functions.php';

// Check if user has permission
if (!hasPermission('manage_suppliers')) {
    echo json_encode(['error' => 'Permission denied']);
    exit;
}

header('Content-Type: application/json');

try {
    // Get the highest batch number (assuming batch_number is stored as a string of digits)
    $stmt = $pdo->query("SELECT MAX(CAST(batch_number AS UNSIGNED)) AS max_batch FROM supplier_receipts");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $next_batch = isset($row['max_batch']) && $row['max_batch'] !== null ? intval($row['max_batch']) + 1 : 1;
    $next_batch_str = str_pad($next_batch, 5, '0', STR_PAD_LEFT);
    echo json_encode(['success' => true, 'next_batch_number' => $next_batch_str]);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
} 